unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    bttResume: TButton;
    bttSuspend: TButton;
    bttTerminate: TButton;
    bttCreate: TButton;
    Panel1: TPanel;
    Label3: TLabel;
    ListBox1: TListBox;
    Button1: TButton;
    Button3: TButton;
    Button4: TButton;
    bttShowThreadClass: TButton;
    Button6: TButton;
    bttDestroy: TButton;
    Panel2: TPanel;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    ProgressBar1: TProgressBar;
    Label4: TLabel;
    LbThreadID: TLabel;
    Label5: TLabel;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure bttResumeClick(Sender: TObject);
    procedure bttSuspendClick(Sender: TObject);
    procedure bttTerminateClick(Sender: TObject);
    procedure bttCreateClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure bttShowThreadClassClick(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure bttDestroyClick(Sender: TObject);
  private
    { Private declarations }
    procedure ShowClassName(Sender: TObject);
    procedure FinalReport();
  public
    { Public declarations }
  end;

TMyThread = class(TThread)
  private
    fTheadID : cardinal;
    fStatus  : string;
    fReport  : string;
    fIndIni  : boolean;
    fIndMin  : integer;
    fIndPos  : integer;
    fIndMax  : integer;
    fCount   : integer;
  protected
    procedure Execute(); override;
  public
    procedure ShowThreadStatus();
    procedure doShowThreadStatus();
    procedure doShowThreadIndicator();
    procedure ShowThreadIndicator();
    procedure ShowThreadReport();
    procedure doShowThreadReport();
  end;

var
  Form1    : TForm1;
  MyThread : TMyThread;

implementation
{$R *.dfm}

// -------------------------------------------------------------------------
//        
//  (   TMyThread.Execute)
// -------------------------------------------------------------------------
//     
procedure TMyThread.doShowThreadStatus();
begin
   Form1.Edit1.Text := fStatus;
end;
//      
procedure TMyThread.ShowThreadStatus();
begin
   Synchronize(doShowThreadStatus);
end;
// -------------------------------------------------------------------------
//    
procedure TMyThread.doShowThreadIndicator();
begin
   if fIndIni
   then begin
     Form1.ProgressBar1.Min := fIndMin;
     Form1.ProgressBar1.Max := fIndMax;
     Form1.ProgressBar1.Position := fIndPos;
   end
   else Form1.ProgressBar1.Position := fIndPos;
end;
//     
procedure TMyThread.ShowThreadIndicator();
begin
   Synchronize(doShowThreadIndicator);
end;
// -------------------------------------------------------------------------
//     
procedure TMyThread.doShowThreadReport();
begin
  Form1.Edit2.Text := fReport;
end;
//      
procedure TMyThread.ShowThreadReport();
begin
  Synchronize(doShowThreadReport);
end;

// -------------------------------------------------------------------------
//       ( EXECUTE)
// -------------------------------------------------------------------------
//  
procedure TMyThread.Execute();
begin
  fCount := 0;
  while not Terminated do
  begin
     fStatus := '  ';
     ShowThreadStatus;
     //    
     fIndIni:=True;
     fIndMin:=1;
     fIndMax:=100;
     fIndPos := fIndMin;
     ShowThreadIndicator;
     repeat
       begin
         fIndIni:=False;
         ShowThreadIndicator;
         Inc(fIndPos);
         if not Terminated then Sleep(5);
       end;
     until (fIndPos > fIndMax) or Terminated;
     //     
     if not Terminated then Inc(fCount);
     fReport := IntToStr(fCount);
     ShowThreadReport;
  end;
  fStatus := '  ';
  ShowThreadStatus;

end;

// -------------------------------------------------------------------------
//     
// -------------------------------------------------------------------------
//  
procedure TForm1.bttCreateClick(Sender: TObject);
begin
   // ,   
   if Assigned(MyThread) then Exit;
   //  
   MyThread := TMyThread.Create(True);
   //     
   CheckBox1.Enabled := False;
   if CheckBox1.Checked
   then begin
       //        Terminate
       MyThread.FreeOnTerminate := True;
       bttDestroy.Enabled := False;
   end
   else begin
       //     Destroy
       MyThread.FreeOnTerminate := False;
       bttDestroy.Enabled := True;
   end;
   //   
   MyThread.fTheadID  := MyThread.ThreadID;
   //   
   LbThreadID.Caption := 'Tread ID : ' + IntToStr(MyThread.fTheadID);
   Form1.Edit1.Text   := '    Suspend';
   //  
   bttCreate.Enabled    := False;
   bttTerminate.Enabled := True;
   bttResume.Enabled    := True;
   bttSuspend.Enabled   := False;
   bttShowThreadClass.Enabled := True;
end;

// -------------------------------------------------------------------------
//    
procedure TForm1.FinalReport();
begin
    //  
    Edit1.Text         := ' ';
    LbThreadID.Caption := 'Tread ID : 0';
    Edit2.Text         := '';
    ProgressBar1.Position := ProgressBar1.Min;
    //  
    bttCreate.Enabled    := True;
    bttTerminate.Enabled := False;
    bttResume.Enabled    := False;
    bttSuspend.Enabled   := False;
    bttDestroy.Enabled   := False;
    bttShowThreadClass.Enabled := False;
    CheckBox1.Enabled := True;
end;

//  
procedure TForm1.bttDestroyClick(Sender: TObject);
begin
  if MyThread <> nil
  then begin
    //  
    if not MyThread.FreeOnTerminate
    then begin
       MyThread.Destroy;
    end;
    MyThread := nil;
    //  
    FinalReport();
  end;
end;

//   
procedure TForm1.bttTerminateClick(Sender: TObject);
begin
  if not Assigned(MyThread) then Exit;
  if not MyThread.Terminated
  then begin
     if MyThread.FreeOnTerminate
     then begin
        //     
        if MyThread.Suspended then MyThread.Resume;
        //    
        MyThread.Terminate;
        //    
        Sleep(100);
        Edit1.Text := '   ';
        MyThread := nil;
        //  
        FinalReport();
     end
     else begin
        //  
        MyThread.Terminate;
        //   
        bttTerminate.Enabled := False;
        bttResume.Enabled    := False;
        bttSuspend.Enabled   := False;
     end;
  end;
end;

// -------------------------------------------------------------------------
//   
// -------------------------------------------------------------------------
//   
procedure TForm1.bttResumeClick(Sender: TObject);
begin
 if not Assigned(MyThread) then Exit;
 // Resume
 if MyThread.Suspended then MyThread.Resume;
 Edit1.Text := ' Resume  ';
 //  
 bttCreate.Enabled    := False;
 bttTerminate.Enabled := True;
 bttResume.Enabled    := False;
 bttSuspend.Enabled   := True;
end;
// -------------------------------------------------------------------------
//   
procedure TForm1.bttSuspendClick(Sender: TObject);
begin
  if not Assigned(MyThread) then Exit;
  // Suspend
  if not MyThread.Suspended then MyThread.Suspend;
  //       
  MyThread.Priority:=tpLowest;
  Edit1.Text := ' Suspend  . Priority : tpLowest';
  //  
  bttCreate.Enabled    := False;
  bttTerminate.Enabled := True;
  bttResume.Enabled    := True;
  bttSuspend.Enabled   := False;
end;
// -------------------------------------------------------------------------
//   
procedure TForm1.FormCreate(Sender: TObject);
begin
 Edit1.Text := '  ';
 //  
 bttCreate.Enabled    := True;
 bttTerminate.Enabled := False;
 bttResume.Enabled    := False;
 bttSuspend.Enabled   := False;
end;

// -------------------------------------------------------------------------
//   
// -------------------------------------------------------------------------
//    
procedure TForm1.ShowClassName(Sender: TObject);
var
  ClassRef: TClass;
begin
  ListBox1.Clear;
  try
    if Assigned(Sender)
    then begin
      ClassRef := Sender.ClassType;
      while ClassRef <> nil do
      begin
        ListBox1.Items.Add(ClassRef.ClassName);
        ClassRef := ClassRef.ClassParent;
      end;
    end;
  except
      ShowMessage('    ');
  end;
end;

//   
procedure TForm1.Button6Click(Sender: TObject);
begin
  ShowClassName(Application);
end;

//   
procedure TForm1.Button1Click(Sender: TObject);
begin
 ShowClassName(Form1);
end;

//   
procedure TForm1.Button3Click(Sender: TObject);
begin
  ShowClassName(Form1.Button3);
end;

//     
procedure TForm1.Button4Click(Sender: TObject);
begin
  ShowClassName(Form1.Edit2);
end;

//   
procedure TForm1.bttShowThreadClassClick(Sender: TObject);
begin
  if  Assigned(MyThread)
  then  ShowClassName(MyThread)
  else ShowMessage('  ');
end;

end.
